<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class OrdenCompra extends Model 
{

    protected $table = 'orden_compra';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function factura()
    {
        return $this->hasMany('App\Models\Factura');
    }

    public function detalle()
    {
        return $this->hasMany('App\Models\DetalleOc');
    }

    public function remito()
    {
        return $this->hasMany('App\Models\Remito');
    }

    public function proveedor()
    {
        return $this->belongsTo('App\Models\Proveedor');
    }

}